<?php
 if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');


require_once('include/vCard.php');

if(isset($_SESSION['authenticated_user_language']) && $_SESSION['authenticated_user_language'] != ''){
    $current_language = $_SESSION['authenticated_user_language'];
}
else{
    $current_language = $sugar_config['default_language'];
}

//set module and application string arrays based upon selected language
$app_strings = return_application_language($current_language);
$app_list_strings = return_app_list_strings_language($current_language);

class qMerge_c extends vCard{
    
        function loadContact($contactid, $module='Contacts') {
        global $app_list_strings;

        require_once($GLOBALS['beanFiles'][$GLOBALS['beanList'][$module]]);
        $contact = new $GLOBALS['beanList'][$module]();
        $contact->retrieve($contactid);
        
        // cn: bug 8504 - CF/LB break Outlook's vCard import
        $bad = array("\n", "\r");
        $good = array("=0A", "=0D");
        $encoding = '';
        /*if(strpos($contact->primary_address_street, "\n") || strpos($contact->primary_address_street, "\r")) {
            $contact->primary_address_street = str_replace($bad, $good, $contact->primary_address_street);
            $encoding = 'QUOTED-PRINTABLE';
        }
        */
        
        $this->setName(from_html($contact->first_name), from_html($contact->last_name), $app_list_strings['salutation_dom'][from_html($contact->salutation)]);
        if ( isset($contact->birthdate) )
            $this->setBirthDate(from_html($contact->birthdate));
        $this->setPhoneNumber(from_html($contact->phone_fax), 'FAX');
        $this->setPhoneNumber(from_html($contact->phone_home), 'HOME');
        $this->setPhoneNumber(from_html($contact->phone_mobile), 'CELL');
        $this->setPhoneNumber(from_html($contact->phone_work), 'WORK');
        $this->setEmail(from_html($contact->email1));
        $this->setAddress(from_html($contact->primary_address_street), from_html($contact->primary_address_city), from_html($contact->primary_address_state), from_html($contact->primary_address_postalcode), from_html($contact->primary_address_country), 'WORK', $encoding);
        if ( isset($contact->account_name) )
            $this->setORG(from_html($contact->account_name), from_html($contact->department));
        else
            $this->setORG('', from_html($contact->department));
        $this->setTitle($contact->title);
    }
    
    
    function saveqMerge_c(){
        global $locale;
        
        $content = $this->toString();
        header("Content-Disposition: attachment; filename={$this->name}.doc");
        //header("Content-Type: text; charset=".$locale->getExportCharset());
        header("Content-Type: application/msword; charset=".$locale->getExportCharset());
        header("Expires: Mon, 26 Jul 1997 05:00:00 GMT" );
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT" );
        header("Cache-Control: max-age=0");
        header("Pragma: public");
        header("Content-Length: ".strlen($content));

        print $locale->translateCharset($content, 'UTF-8', $locale->getExportCharset());
    }
    
    function displayProperty($prop){
       if ($this->getProperty($prop))
            return $content.=$this->getProperty($prop)."\n";
       else
            return '';
    }
    
    function setORG($org, $dep){
        $this->setProperty("ORG","$org" );    
    }
    
    function setName($first_name, $last_name, $prefix){
        $this->name = strtr($first_name.'_'.$last_name, ' ' , '_');
        $this->setProperty('N',trim($first_name.' ' . $last_name ));
        $this->setProperty('FN',trim("$prefix $first_name $last_name")); 
        $this->setProperty('SAL',"Dear " . trim("$first_name $last_name:") );  
    }
    
    function toString(){
        $content=date('m/d/y')."\n\n";
        $content.=$this->displayProperty('FN');
        $content.=$this->displayProperty('TITLE');
        //$content.=$this->displayProperty('ORG');
        $content.=$this->displayProperty('ADR;WORK');
        $content.="\n\n" . $this->displayProperty('SAL');  

        
        return $content;
    }
    
    function setAddress($address, $city, $state,$postal, $country, $type, $encoding=''){
        if(!empty($encoding)) {
            $encoding = ";ENCODING={$encoding}";
        }
        if ($country=="USA" || $country="United States" || $country="United States of America")
           $this->setProperty("ADR;$type$encoding","$address\n$city, $state  $postal" ); 
        else    
            $this->setProperty("ADR;$type$encoding","$address\n$city, $state  $postal\n$country" );    
    }
}  

$q = new qMerge_c();

if(isset($_REQUEST['merge_module'])) {
    $module = clean_string($_REQUEST['merge_module']);
    $q->loadContact($_REQUEST['qmerge_c_id'], $module);
    $q->saveqMerge_c();
}
    


?>
